<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/nmfp2"
	xmlns:ns3="http://www.sec.gov/edgar/nmfp2common">
	
	<xsl:template name="item3_partB">
		<xsl:for-each select="m1:classLevelInfo">
			<h3>Part B: Class-Level Information about the Fund</h3>
			<h4 style="padding:10px">For each Class of the Series (regardless of the number of shares outstanding in the Class), disclose the following:</h4>
			<table>
				<tr>
					<td class="label"><b>Item B.1</b> EDGAR Class identifier.</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="m1:classesId" />
						</div>					
					</td>
				</tr>
				<tr>
					<td class="label"><b>Item B.2</b> Minimum initial investment.</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:minInitialInvestment) &gt; 0">
								<xsl:value-of select='format-number(m1:minInitialInvestment, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>					
					</td>
				</tr>
				<tr>
					<td class="label"><b>Item B.3</b> Net assets of the Class, to the nearest cent.</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:netAssetsOfClass) &gt; 0">
								<xsl:value-of select='format-number(m1:netAssetsOfClass, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>					
					</td>
				</tr>
				<tr>
					<td class="label">
						<b>Item B.4</b> Number of shares outstanding, to the nearest hundredth.
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:numberOfSharesOutstanding) &gt; 0">
								$<xsl:value-of select='format-number(m1:numberOfSharesOutstanding ,  "ddd,ddd,ddd,dd0.00dd", "percentage")' />
							</xsl:if>
						</div>					
					</td>
				</tr>	
				<tr>
					<td class="label">
						<b>Item B.5</b> Net asset value per share. Provide the net asset value per share, calculated using available market quotations (or an appropriate substitute that reflects current market conditions), rounded to the fourth decimal place in the case of a fund with a $1.0000 share price (or an equivalent level of accuracy for funds with a different share price), as of the close of business on each Friday during the month reported (if the reporting date falls on a holiday or other day on which the fund does not calculate the net asset value per share, provide the value as of the close of business on the date in that week last calculated):
					</td>
					<td>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							i. Friday, week 1:
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:netAssetPerShare/ns3:fridayWeek1) &gt; 0">
								<xsl:value-of select='format-number(m1:netAssetPerShare/ns3:fridayWeek1, "$#,##0.0000")' />
							</xsl:if>
						</div>									
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							ii. Friday, week 2:
						</blockquote>
					</td>	
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:netAssetPerShare/ns3:fridayWeek2) &gt; 0">
								<xsl:value-of select='format-number(m1:netAssetPerShare/ns3:fridayWeek2, "$#,##0.0000")' />
							</xsl:if>
						</div>									
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							iii. Friday, week 3:
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:netAssetPerShare/ns3:fridayWeek3) &gt; 0">
								<xsl:value-of select='format-number(m1:netAssetPerShare/ns3:fridayWeek3, "$#,##0.0000")' />
							</xsl:if>
						</div>									
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							iv. Friday, week 4:
						</blockquote>
					</td>	
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:netAssetPerShare/ns3:fridayWeek4) &gt; 0">
								<xsl:value-of select='format-number(m1:netAssetPerShare/ns3:fridayWeek4, "$#,##0.0000")' />
							</xsl:if>
						</div>									
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							v. Friday, week 5 (if applicable):
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="string(m1:netAssetPerShare/ns3:fridayWeek5) &gt; -10000"> <!-- DCS says that it can be a negative -->
								<xsl:value-of select='format-number(m1:netAssetPerShare/ns3:fridayWeek5, "$#,##0.0000")' />
							</xsl:if>
						</div>									
					</td>
				</tr>
				<tr>
					<td class="label">
						<b>Item B.6</b> Net shareholder flow.  Provide the aggregate weekly gross subscriptions 
						(including dividend reinvestments) and gross redemptions, rounded to the nearest cent, 
						as of the close of business on each Friday during the month reported (if the reporting 
						date falls on a holiday or other day on which the fund does not calculate the gross 
						subscriptions or gross redemptions, provide the value as of the close of business on 
						the date in that week last calculated):
					</td>
					<td></td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							a. Friday, week 1:
						</blockquote>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							<blockquote>
								i. Weekly gross subscriptions <font style="font-size:0.9em">(including dividend reinvestments):</font>
							</blockquote>
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:fridayWeek1/m1:weeklyGrossSubscriptions) &gt; 0">
								<xsl:value-of select='format-number(m1:fridayWeek1/m1:weeklyGrossSubscriptions, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>				
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							<blockquote>
								ii. Weekly gross redemptions:
							</blockquote>
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:fridayWeek1/m1:weeklyGrossRedemptions) &gt; 0">
								<xsl:value-of select='format-number(m1:fridayWeek1/m1:weeklyGrossRedemptions, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>				
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							b. Friday, week 2:
						</blockquote>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							<blockquote>
								i. Weekly gross subscriptions
								<font style="font-size:0.9em">(including dividend reinvestments):</font>
							</blockquote>
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:fridayWeek2/m1:weeklyGrossSubscriptions) &gt; 0">
								<xsl:value-of select='format-number(m1:fridayWeek2/m1:weeklyGrossSubscriptions, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>									
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							<blockquote>
								ii. Weekly gross redemptions:
							</blockquote>
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:fridayWeek2/m1:weeklyGrossRedemptions) &gt; 0">
								<xsl:value-of select='format-number(m1:fridayWeek2/m1:weeklyGrossRedemptions, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>				
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							c. Friday, week 3:
						</blockquote>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							<blockquote>
								i. Weekly gross subscriptions
								<font style="font-size:0.9em">(including dividend reinvestments):</font>
							</blockquote>
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:fridayWeek3/m1:weeklyGrossSubscriptions) &gt; 0">
								<xsl:value-of select='format-number(m1:fridayWeek3/m1:weeklyGrossSubscriptions, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>									
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							<blockquote>
								ii. Weekly gross redemptions:
							</blockquote>
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:fridayWeek3/m1:weeklyGrossRedemptions) &gt; 0">
								<xsl:value-of select='format-number(m1:fridayWeek3/m1:weeklyGrossRedemptions, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>				
					</td>
				</tr>			
				<tr>
					<td class="label">
						<blockquote>
							d. Friday, week 4:
						</blockquote>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							<blockquote>
								i. Weekly gross subscriptions
								<font style="font-size:0.9em">(including dividend reinvestments):</font>
							</blockquote>
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:fridayWeek4/m1:weeklyGrossSubscriptions) &gt; 0">
								<xsl:value-of select='format-number(m1:fridayWeek4/m1:weeklyGrossSubscriptions, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>									
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							<blockquote>
								ii. Weekly gross redemptions:
							</blockquote>
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:fridayWeek4/m1:weeklyGrossRedemptions) &gt; 0">
								<xsl:value-of select='format-number(m1:fridayWeek4/m1:weeklyGrossRedemptions, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>				
					</td>
				</tr>	
				<tr>
					<td class="label">
						<blockquote>
							e. Friday, week 5:
						</blockquote>
					</td>
				</tr>		
				<tr>
					<td class="label">
						<blockquote>
							<blockquote>
								i. Weekly gross subscriptions
								<font style="font-size:0.9em">(including dividend reinvestments):</font>
							</blockquote>
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="string(m1:fridayWeek5/m1:weeklyGrossSubscriptions) &gt;= 0">
								$<xsl:value-of select='format-number(m1:fridayWeek5/m1:weeklyGrossSubscriptions ,  "ddd,ddd,ddd,dd0.00", "percentage")' />
							</xsl:if>
						</div>									
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							<blockquote>
								ii. Weekly gross redemptions:
							</blockquote>
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="string(m1:fridayWeek5/m1:weeklyGrossRedemptions) &gt;= 0">
								$<xsl:value-of select='format-number(m1:fridayWeek5/m1:weeklyGrossRedemptions ,  "ddd,ddd,ddd,dd0.00", "percentage")' />
							</xsl:if>
						</div>				
					</td>
				</tr>	
				<tr>
					<td class="label">
						<blockquote>
							f. Total for the month reported:
						</blockquote>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							<blockquote>
								i. Monthly gross subscriptions
								<font style="font-size:0.9em">(including dividend reinvestments):</font>
							</blockquote>
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:totalForTheMonthReported/m1:weeklyGrossSubscriptions) &gt; 0">	
								<xsl:value-of select='format-number(m1:totalForTheMonthReported/m1:weeklyGrossSubscriptions, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>									
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							<blockquote>
								ii. Monthly gross redemptions:
							</blockquote>
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="count(m1:totalForTheMonthReported/m1:weeklyGrossRedemptions) &gt; 0">
								<xsl:value-of select='format-number(m1:totalForTheMonthReported/m1:weeklyGrossRedemptions, "$###,###,###,##0.00")' />
							</xsl:if>
						</div>				
					</td>
				</tr>
			</table>
			<table>
				<tr>
					<td class="label"><b>Item B.7</b> 7-day net yield, as calculated under Item 26(a)(1) of Form N-1A (§ 274.11A of this chapter).</td>
					<td>
						<div class="fakeBox2">
							<xsl:if test="string(m1:sevenDayNetYield) &gt;= -1.9999">
								<xsl:variable name="sevenDayNetYield" select='format-number(m1:sevenDayNetYield, "0.0000", "percentage")' />
								<xsl:value-of select='format-number(100 * $sevenDayNetYield ,  "dd0.00", "percentage")' />%
							</xsl:if>
						</div>						
					</td>
				</tr>
				<tr>
					<td class="label">
						<b>Item B.8</b> During the reporting period, did any Person pay for, or waive all or part of the fund's operating expenses or management fees? If Yes, answer Item B.8.a.
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="string(m1:personPayForFundFlag) = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> Yes
							</xsl:otherwise>
						</xsl:choose> &#160;
						<xsl:choose>
							<xsl:when test="string(m1:personPayForFundFlag) = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
							</xsl:otherwise>
						</xsl:choose>						
					</td>
				</tr>

				<xsl:if test="string(m1:personPayForFundFlag) = 'Y'">
					<tr>
						<td class="label">
							<blockquote>
								a. Provide the name of the Person and describe the nature and amount of the expense payment or fee waiver, or both (reported in dollars).
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="m1:nameOfPersonDescExpensePay" />
							</div>
						</td>
					</tr>
				</xsl:if>
			</table>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>

